const initTurnstile = () => {
	document.querySelectorAll('.cf-turnstile:not(.inited)').forEach(function (item) {
		item.classList.add('inited');

		turnstile.render(item, {
			sitekey : item.dataset.sitekey,
			callback: function (token) {
			},
		});
	});
};

global.naja.addEventListener("complete", (e) => {
	try {
		initTurnstile();
	} catch (e) {
	}
});

const scriptLoaded = function () {
	initTurnstile();
};


let script = document.createElement("script");
script.setAttribute("src", "https://challenges.cloudflare.com/turnstile/v0/api.js?render=explicit");
script.setAttribute("defer", "");
script.setAttribute("async", "");
script.addEventListener("load", scriptLoaded, false);
document.body.appendChild(script);
