<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\Model\FileRequests;
use Nette\Application\Responses\FileResponse;
use Nette\DI\Attributes\Inject;

class FileResponsePresenter extends BasePresenter
{
	#[Inject]
	public FileRequests $fileRequests;

	protected function startup()
	{
		parent::startup();
	}

	/*******************************************************************************************************************
	 * ===============================  Render
	 */

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(string $data = ''): void
	{
		if (is_numeric($data)) {
			$fileRequest = $this->fileRequests->get($data);
			if ($fileRequest) {
				$data = $fileRequest->getData();
			}
		}

		$data = unserialize(base64_decode($data));

		if (isset($data['externalLink'])) {
			$this->redirectUrl($data['externalLink']);
		}

		if ($data['file'] && file_exists($data['file'])) {
			$basename      = $data['filename'] ?: basename((string) $data['file']);
			$forceDownload = $data['download'] ?? false;
			$contentType   = $data['contentType'] ?? null;
			$this->sendResponse(new FileResponse($data['file'], $basename, $contentType, $forceDownload));
		}

		exit;
	}

	public function actionFromDataDir(string $path): void
	{
		$file = DATA_DIR . DS . $path;

		if (file_exists($file)) {
			$basename = basename($file);
			$this->sendResponse(new FileResponse($file, $basename, null, true));
		}

		exit;
	}
}
