<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\Model\Translation\TextTranslator;

class TranslatorPresenter extends BasePresenter
{
	protected TextTranslator $textTranslator;

	public function __construct(
		TextTranslator $textTranslator
	)
	{
		$this->textTranslator = $textTranslator;
	}

	public function actionDeepl(): void
	{
		$text       = $this->getHttpRequest()->getPost('text');
		$sourceLang = $this->getHttpRequest()->getPost('sourceLang');
		$targetLang = $this->getHttpRequest()->getPost('targetLang');

		if (!$text || !$sourceLang || !$targetLang) {
			$this->sendJson([
				'error' => 'Missing parameters',
			]);
		}

		$this->sendJson([
			'result' => $this->textTranslator->translateHtml($text, $sourceLang, $targetLang),
		]);
	}
}
