<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\AdminModule\Components\WebColors\ColorsForm;
use Core\AdminModule\Components\WebColors\IColorsFormFactory;
use Core\AdminModule\Model\Sites;
use Nette\Application\UI\Multiplier;

class WebColorsPresenter extends BasePresenter
{
	/** @var Sites @inject */
	public $sitesService;

	protected function startup()
	{
		parent::startup();
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'settings'))
			$this->error();

		$this->setHeader('admin.title.webColors', 'fas fa-palette');
	}

	/*******************************************************************************************************************
	 * ===============================  Render
	 */

	public function renderDefault(): void
	{
		$this->template->sites = $this->sitesService->getAll();
	}

	/*******************************************************************************************************************
	 * ===============================  Handle
	 */

	/*******************************************************************************************************************
	 * ===============================  Action
	 */

	public function actionDefault(): void
	{
	}

	/*******************************************************************************************************************
	 * ===============================  Components
	 */

	protected function createComponentColorsForm(IColorsFormFactory $factory): Multiplier
	{
		return new Multiplier(function(string $ident) use ($factory): ColorsForm {
			$control = $factory->create($ident);

			return $control;
		});
	}
}
