<?php declare(strict_types = 1);

namespace Core\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Contributte\Translation\Translator;
use Core\Model\Lang\Langs;
use Core\Model\StaticTexts;
use Apitte\Core\Annotation\Controller\RequestParameters;
use Apitte\Core\Annotation\Controller\RequestParameter;

/**
 * @Path("/static-texts")
 */
class StaticTextsController extends BaseController
{
	protected StaticTexts $staticTexts;
	protected Translator $translator;
	protected Langs $langs;

	public function __construct(StaticTexts $staticTexts, Translator $translator, Langs $langs)
	{
		$this->staticTexts = $staticTexts;
		$this->translator = $translator;
		$this->langs = $langs;
	}

	/**
	 * @Path("/catalogue/{catalogueName}")
	 * @Method("GET")
	 * @RequestParameters({
	 *      @RequestParameter(name="catalogueName", type="string", required=true)
	 * })
	 */
	public function catalogue(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		$catalogueName = $request->getParameter('catalogueName');
		$langFullTag = $this->langs->getLang($this->translator->getLocale())->getFullTag();

		$result = [];

		$messages = $this->staticTexts->getMergedMessages();
		if (isset($messages[$catalogueName][$langFullTag])) {
			foreach ($messages[$catalogueName][$langFullTag] as $k => $message) {
				$result[$k] = $message;
			}
		}

		return $response->writeJsonBody($result)->withStatus(ApiResponse::S200_OK);
	}

}