<?php declare(strict_types = 1);

namespace Core\ApiModule\Model\Services;

use Contributte\Translation\Translator;
use Core\Model\Entities\EntityManagerDecorator;
use Nette\DI\Container;
use Nette\Neon\Neon;
use Nette\Utils\Finder;
use Nette\Utils\Validators;

class AppState
{
	protected Translator $translator;
	protected EntityManagerDecorator $em;
	protected Container $container;

	public function __construct(Translator $translator, EntityManagerDecorator $em, Container $container)
	{
		$this->translator = $translator;
		$this->em = $em;
		$this->container = $container;
	}

	public function isSetSmtpUsername(): bool
	{
		$allConfig = self::allConfig();
		$username = null;

		if (isset($allConfig['mail']['username'])) {
			$username = Validators::isNone($allConfig['mail']['username']) ? null : $allConfig['mail']['username'];
		} else if (isset($allConfig['parameters']['mailSender']['smtp']['username'])) {
			$username = $allConfig['parameters']['mailSender']['smtp']['username'];
		}

		return $username && explode('@', $username)[1] !== 'pshk.cz';
	}

	public function isFrontTranslated(): bool
	{
		$whitelist = $this->translator->getLocalesWhitelist() ?? [];

		$files = [];
		foreach (Finder::findFiles('*.neon')->in(APP_DIR . '/lang') as $file) {
			$files[] = [
				'name' => $file->getFilename(),
				'path' => $file->getPathname()
			];

			$content = Neon::decodeFile($file->getPathname());

			if (!$content) {
				return false;
			}
		}

		$domains = [];
		foreach ($files as $file) {
			[$domain, $lang, $ext] = explode('.', $file['name']);
			$domains[$domain] = isset($domains[$domain]) ? ($domains[$domain] + 1) : 1;
		}

		foreach ($domains as $domain => $langOccurrences) {
			if ($langOccurrences < count($whitelist)) {
				return false;
			}
		}

		return true;
	}

	public function existEshopProductsComparisonFeeds(): ?bool
	{
		if (!class_exists('\EshopProductsComparison\DI\EshopProductsComparisonExtension') || !class_exists('\EshopProductsComparison\FrontModule\Model\Export\XmlService')) {
			return null;
		}

		$dir = WWW_DIR . DS . \EshopProductsComparison\FrontModule\Model\Export\XmlService::EXPORT_DIR_NAME;

		if (!file_exists($dir)) {
			return false;
		}

		return iterator_count(Finder::findFiles('*.xml')->in($dir)) > 0;
	}

	protected static function allConfig(): array
	{
		$files = [
			APP_DIR . '/config/app/parameters.neon',
			APP_DIR . '/config/config.neon',
			APP_DIR . '/config/config.public.neon'
		];

		$config = [];
		foreach ($files as $file) {
			if (file_exists($file)) {
				$config = array_merge_recursive($config, Neon::decodeFile($file));
			}
		}

		return $config;
	}

}
