<?php declare(strict_types = 1);

namespace Core\Components\Cookie;

use Core\FrontModule\Model\CookieServices;
use Core\Model\SystemConfig;
use Core\Model\UI\BaseControl;
use Nette\Utils\Json;

class CookieBar extends BaseControl
{
	public function __construct(protected CookieServices $cookieServices)
	{
	}

	public function render(): void
	{
		$this->template->excludeCookieFilesFromErase = SystemConfig::load('cookieBar.excludeCookieFilesFromErase');
		$this->template->theme                       = SystemConfig::load('cookieBar.theme');
		$this->template->services                    = Json::encode($this->cookieServices->getAllWithDefaults());
		$this->template->render($this->getTemplateFile());
	}
}
