<?php declare(strict_types = 1);

namespace Core\Console\Cache;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Exception;
use Nette\Caching\Cache;
use Nette\Caching\Storage;
use Nette\DI\Attributes\Inject;
use Nette\Utils\FileSystem;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

#[AsCommand(
	name       : 'cache:clean',
	description: 'Generate eshop catalog cache',
)]
class Clean extends AbstractCommand
{
	#[Inject]
	public Storage $cacheStorage;

	protected function configure(): void
	{
	}

	protected function executeSchemaCommand(
		InputInterface                $input,
		OutputInterface               $output,
		Doctrine\ORM\Tools\SchemaTool $schemaTool,
		array                         $metadatas,
		SymfonyStyle                  $ui,
	)
	{
		$output->writeln('CLEAN CACHE');

		try {
			$cache = new Cache($this->cacheStorage);
			$cache->clean([Cache::ALL => true]);
			FileSystem::delete(TMP_DIR);
			FileSystem::createDir(TMP_DIR);

			$output->writeLn('<info>[OK]</info>');
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
