<?php declare(strict_types = 1);

namespace Core\Console\Seo;

use Core\FrontModule\Model\SiteMap;
use Core\Model\Lang\Langs;
use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Exception;
use Nette\Application\LinkGenerator;
use Nette\DI\Attributes\Inject;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

#[AsCommand(
	name       : 'seo:generate-robots-txt',
	description: 'Generate robots.txt',
)]
class GenerateRobotsTxt extends AbstractCommand
{
	#[Inject]
	public SiteMap $siteMap;

	#[Inject]
	public LinkGenerator $linkGenerator;

	#[Inject]
	public Langs $langs;

	protected function configure(): void
	{
	}

	protected function executeSchemaCommand(
		InputInterface                $input,
		OutputInterface               $output,
		Doctrine\ORM\Tools\SchemaTool $schemaTool,
		array                         $metadatas,
		SymfonyStyle                  $ui,
	)
	{
		$output->writeln('GENERATE ROBOTS.TXT');

		try {
			$content = "User-agent: *\n" .
				"Disallow: /admin\n" .
				"Disallow: /assets/admin\n" .
				"Disallow: /assets/admin2\n" .
				"Disallow: /trafficbot.life\n";

			$content .= "\n";

			file_put_contents(WWW_DIR . '/robots.txt', $content);

			$output->writeLn('<info>[OK] - robots.txt created</info>');
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
