<?php declare(strict_types = 1);

namespace Core\Console\Utils;

use Core\AdminModule\Model\Redirects;
use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Exception;
use Nette\DI\Attributes\Inject;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

#[AsCommand(
	name       : 'utils:validate-redirects',
	description: 'Validate redirects',
)]
class ValidateRedirects extends AbstractCommand
{
	#[Inject]
	public Redirects $redirects;

	protected function configure(): void
	{
		$this->addOption('offset', null, InputOption::VALUE_REQUIRED)
			->addOption('limit', null, InputOption::VALUE_REQUIRED);
	}

	protected function executeSchemaCommand(
		InputInterface                $input,
		OutputInterface               $output,
		Doctrine\ORM\Tools\SchemaTool $schemaTool,
		array                         $metadatas,
		SymfonyStyle                  $ui,
	)
	{
		$output->writeln('VALIDATE REDIRECTS');

		try {
			try {
				$this->redirects->validateRedirects(
					(int) $input->getOption('offset'),
					(int) $input->getOption('limit'),
				);
				$output->writeLn('<info>[OK] - data updated</info>');
			} catch (Exception $e) {
				$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
			}
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 0;
	}
}
