<?php declare(strict_types = 1);

namespace Core\FrontModule\Components;

use Core\FrontModule\Model\SearchItemsCollection;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Utils\ArrayHash;

class SearchForm extends BaseControl
{
	public function __construct(protected SearchItemsCollection $searchItemsCollection)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();

		$form->addText('q', 'default.search');
		$form->addSubmit('submit', 'default.send');

		$form->onSuccess[] = function(BaseForm $form, ArrayHash $values): never {
			$this->presenter->redirect(':Core:Front:Default:search', ['q' => $values->q]);
		};

		return $form;
	}
}
