<?php declare(strict_types = 1);

namespace Core\FrontModule\Model;

use Core\Model\Entities\Redirect;
use Core\Model\Helpers\BaseFrontEntityService;
use Nette\Application\LinkGenerator;
use Nette\DI\Container;

class Redirects extends BaseFrontEntityService
{
	protected $entityClass = Redirect::class;

	public function __construct(protected Container $container)
	{
	}

	public function addNew(string $from, string $to, string $siteIdent, string $lang): void
	{
		$this->em->getConnection()->insert('core__redirect', [
			'`title`'      => '',
			'`from`'       => ltrim($from, '/'),
			'`to`'         => ltrim($to, '/'),
			'`site_ident`' => $siteIdent,
			'`lang`'       => $lang,
		]);
	}

	public function findRedirect(string $url, bool $redirect = true): ?array
	{
		$r = $this->getEr()->createQueryBuilder('r')->select('r.to, r.redirectCode')
			->where('r.from = :from')->andWhere('r.to IS NOT NULL')
			->setParameters(['from' => ltrim($url, '/')])
			->setMaxResults(1)
			->getQuery()->getOneOrNullResult();

		$result = null;

		if ($r) {
			if (str_starts_with((string) $r['to'], ':')) {
				$tmp       = explode(' ', (string) $r['to']);
				$presenter = array_shift($tmp);
				foreach ($tmp as $k => $v) {
					if (is_numeric($v))
						$tmp[$k] = (int) $v;
				}

				/** @var LinkGenerator $linkGenerator */
				$linkGenerator = $this->container->getService('application.linkGenerator');
				$result        = [
					'link' => $linkGenerator->link($presenter, $tmp),
					'code' => $r['redirectCode'],
				];
			} else {
				$result = [
					'link' => $r['to'],
					'code' => $r['redirectCode'],
				];
			}
		}

		if ($redirect && $result) {
			header('Location: /' . ltrim((string) $result['link'], '/'), true, (int) $result['code']);
			exit;
		}

		return $result;
	}
}
