<?php declare(strict_types = 1);

namespace Core\Model;

abstract class Config
{
	protected static array  $params;
	protected static string $separator = '.';

	public function __construct(?array $params)
	{
		self::$params[static::class] = $params ?: [];
	}

	public static function setParams(array $params): void
	{
		self::$params[static::class] = $params;
	}

	/**
	 * @param string $key
	 */
	public static function setParam($key, mixed $value): void
	{
		/** @phpstan-ignore-next-line */
		$keys = explode(self::$separator, $key) ?: [];
		$key  = array_pop($keys);

		$arr = &self::$params[static::class];
		foreach ($keys as $k) {
			if (!isset($arr[$k])) {
				break;
			}

			$arr = &$arr[$k];
		}

		if (isset($arr[$key])) {
			$arr[$key] = $value;
		}
	}

	public static function addParams(array $params): void
	{
		foreach ($params as $k => $v) {
			/** @phpstan-ignore-next-line */
			$keys    = explode(self::$separator, $k) ?: [];
			$arr     = &self::$params[static::class];
			$lastKey = array_pop($keys);

			foreach ($keys as $key) {
				if (!isset($arr[$key])) {
					break;
				}

				$arr = &$arr[$key];
			}

			$arr[$lastKey] = $v;
		}
	}

	/**
	 * @param string $key
	 *
	 * @return mixed|null
	 */
	public function get($key, mixed $default = null)
	{
		return self::load($key, $default);
	}

	/**
	 * @return array|mixed|null
	 */
	public static function load(string $key, mixed $default = null)
	{
		/** @phpstan-ignore-next-line */
		$keys = explode(self::$separator, $key) ?: [];
		$arr  = self::$params[static::class] ?? [];

		foreach ($keys as $key) {
			if (!isset($arr[$key])) {
				return $default;
			}

			$arr = $arr[$key];
		}

		/** @phpstan-ignore-next-line */
		return $arr ?? $default;
	}

	public static function getTemplate(string $file): string
	{
		return APP_DIR . static::load('layouts.frontTemplatesPath') . DS . static::load(
				'layouts.' . $file,
				$file . '.latte',
			);
	}
}
