<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\ArrayHash;

trait TSeo
{
	/**
	 * @var array
	 */
	#[ORM\Column(name: 'seo', type: Types::ARRAY, nullable: true)]
	protected $seo;

	/**
	 * @return mixed|null
	 */
	public function getSeo(?string $key = null, ?string $lang = null)
	{
		if (!$lang && isset($this->locale)) {
			$lang = $this->locale;
		}

		if ($key && $lang && isset($this->seo[$key][$lang])) {
			return $this->seo[$key][$lang];
		}

		if ($key) {
			return $this->seo[$key] ?? null;
		}

		return $this->seo;
	}

	public function setSeo(string|array|ArrayHash $key, mixed $value = null): self
	{
		if ($key instanceof ArrayHash) {
			$key = (array) $key;
		}

		if (is_array($key)) {
			foreach ($key as $k => $v) {
				if (is_null($v) && $k !== 'addToSiteMap') {
					unset($key[$k]);
				}
			}

			$this->seo = $key;
		} else {
			if ($value) {
				$this->seo[$key] = $value;
			} else {
				unset($this->seo[$key]);
			}
		}

		return $this;
	}
}
