<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Core\Model\Helpers\Arrays;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\DBAL\Types\Types;
use Nette\Utils\Json;

#[ORM\Table(name: 'core__variable')]
#[ORM\Entity]
class Variable
{
	#[ORM\Id]
	#[ORM\Column(name: '`key`', type: Types::STRING, length: 255, nullable: false)]
	public string $key;

	#[ORM\Id]
	#[ORM\Column(name: 'lang', type: Types::STRING, length: 2, nullable: false)]
	public string $lang;

	#[ORM\Column(name: '`value`', type: Types::TEXT, nullable: true)]
	protected ?string $value = null;

	public function __construct(string $key, string $lang, ?string $value = null)
	{
		$this->key  = $key;
		$this->lang = $lang;
		$this->setValue($value);
	}

	/**
	 * @param string|int|float|null|array $value
	 *
	 * @return void
	 * @throws \Nette\Utils\JsonException
	 */
	public function setValue($value): void
	{
		if (is_array($value)) {
			$value = Json::encode($value);
		}

		if ($value instanceof \DateTimeInterface) {
			$value = $value->format('Y-m-d H:i:s');
		}

		$this->value = (string) $value;
	}

	public function getValue(): string
	{
		if (Arrays::isJson($this->value)) {
			return Json::decode($this->value, Json::FORCE_ARRAY);
		}

		return (string) $this->value;
	}
}
