<?php declare(strict_types = 1);

namespace Core\Model\Event;

class EntityRemoveEvent extends \Symfony\Contracts\EventDispatcher\Event
{
	public string $entityId;
	public object $entity;
	public array  $data = [];

	public function __construct(string $entityId, object $entity, array $data = [])
	{
		$this->entityId = $entityId;
		$this->entity   = $entity;
		$this->data     = $data;
	}
}
