<?php declare(strict_types = 1);

namespace Core\Model\Event;

use Core\Model\Templating\Template;
use Nette\Application\UI\Presenter;
use Symfony\Contracts\EventDispatcher\Event;

class PresenterTemplateEvent extends Event
{
	public Template  $template;
	public Presenter $presenter;

	public array $data = [];

	public function __construct(Template $template, Presenter $presenter)
	{
		$this->template  = $template;
		$this->presenter = $presenter;
	}
}
