<?php declare(strict_types = 1);

namespace Core\Model\Event;

use Symfony\Contracts\EventDispatcher\Event;

class TtSearchEvent extends Event
{
	protected array $result = [];

	public function __construct(public string $q, public array $inputs, public array $values)
	{
	}

	public function addResult(string $type, mixed $data): self
	{
		$this->result[$type] = $data;

		return $this;
	}

	public function getResult(): array { return $this->result; }
}
