<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Exception;
use Nette\Neon\Neon;
use RecursiveArrayIterator;
use RecursiveIteratorIterator;

class Arrays extends \Nette\Utils\Arrays
{
	/**
	 * @param mixed|null $string
	 */
	public static function isJson($string): bool
	{
		if (is_string($string)) {
			json_decode($string);
		} else {
			return false;
		}

		return (json_last_error() === JSON_ERROR_NONE);
	}

	public static function textareaToArray(string $v): array
	{
		return explode("\n", $v);
	}

	public static function setObjectVars(object $object, array $vars): void
	{
		$has = get_object_vars($object);
		foreach ($has as $name => $oldValue) {
			if (array_key_exists($name, $vars)) {
				$object->$name = $vars[$name];
			}
		}
	}

	public static function isNeon(string $string): bool
	{
		try {
			Neon::decode($string);

			return true;
		} catch (Exception) {

			return false;
		}
	}

	public static function hasOnlyNumbers(array $arr): bool
	{
		foreach ($arr as $v) {
			if (!is_numeric($v)) {
				return false;
			}
		}

		return true;
	}

	public static function buildTree(
		array      $flat,
		string     $pidKey = 'parent',
		string     $idKey = 'id',
		string|int $initParentId = 0,
	): array
	{
		$grouped = [];
		foreach ($flat as $sub) {
			$grouped[$sub[$pidKey] ?: 0][] = $sub;
		}

		$fnBuilder = static function($siblings) use (&$fnBuilder, $grouped, $idKey) {
			foreach ($siblings as $k => $sibling) {
				$id = $sibling[$idKey];
				if (isset($grouped[$id])) {
					$sibling['children'] = $fnBuilder($grouped[$id]);
				}
				$siblings[$k] = $sibling;
			}

			return $siblings;
		};

		$tree = $fnBuilder($grouped[$initParentId]);

		return $tree ?: $flat;
	}

	public static function builtSelectOptionsTree(
		array  $tree,
		string $idKey = 'id',
		string $titleKey = 'title',
		string $childrenKey = 'children',
		array  &$options = [],
		int    $deep = 0,
	): array
	{
		foreach ($tree as $n) {
			$options[$n[$idKey]] = ($deep ? str_repeat('--', $deep) . ' ' : '') . $n[$titleKey];

			if (isset($n[$childrenKey]) && is_array($n[$childrenKey])) {
				self::builtSelectOptionsTree($n[$childrenKey], $idKey, $titleKey, $childrenKey, $options, $deep + 1);
			}
		}

		return $options;
	}

	public static function strposa(string $haystack, array $needle, int $offset = 0): bool
	{
		foreach ($needle as $query) {
			if (str_contains($haystack, (string) $query)) {
				return true;
			}
		}

		return false;
	}

	public static function flattenWithDottedKeys(array $array, ?string $keyPrefix = null): array
	{
		$iterator = new RecursiveIteratorIterator(new RecursiveArrayIterator($array));
		$result   = [];
		foreach ($iterator as $leafValue) {
			$keys = [];
			foreach (range(0, $iterator->getDepth()) as $depth) {
				$keys[] = $iterator->getSubIterator($depth)->key();
			}
			$result[($keyPrefix ?? '') . implode('.', $keys)] = $leafValue;
		}

		return $result;
	}

	public static function shuffleAssoc(array $array): array
	{
		$keys = array_keys($array);
		$new  = [];

		shuffle($keys);

		foreach ($keys as $key) {
			$new[$key] = $array[$key];
		}

		return $new;
	}

	public static function search(array $array, callable $condition, bool $preserveKey = true): array
	{
		$return = [];
		foreach ($array as $k => $v) {
			if ($condition($k, $v)) {
				if ($preserveKey) {
					$return[$k] = $v;
				} else {
					$return[] = $v;
				}
			}
		}

		return $return;
	}

}
