<?php declare(strict_types = 1);

namespace Core\Model\Images;

use Nette;

/**
 * @property-read float|int $width
 * @property-read float|int $height
 */
class Size
{
	use Nette\SmartObject;

	/**
	 * @param float|int $width
	 * @param float|int $height
	 */
	public function __construct(private $width, private $height)
	{
	}

	public function getHeight(): float|int
	{
		return $this->height;
	}

	public function getWidth(): float|int
	{
		return $this->width;
	}

	public static function fromFile(string $file): Size
	{
		$tmp = @getimagesize($file);

		return is_array($tmp)
			? new Size($tmp[0], $tmp[1])
			: new Size(0, 0);
	}

}
