<?php declare(strict_types = 1);

namespace Core\Model\MathParser;

use Core\Model\MathParser\Operator\Addition;
use Core\Model\MathParser\Operator\Division;
use Core\Model\MathParser\Operator\Multiplication;
use Core\Model\MathParser\Operator\Subtraction;
use Exception;

abstract class TerminalExpression
{
	public function __construct(protected $value)
	{
	}

	public static function factory($value)
	{
		if (is_object($value) && $value instanceof TerminalExpression) {
			return $value;
		} else if (is_numeric($value)) {
			return new Number($value);
		} else if ($value == '+') {
			return new Addition($value);
		} else if ($value == '-') {
			return new Subtraction($value);
		} else if ($value == '*') {
			return new Multiplication($value);
		} else if ($value == '/') {
			return new Division($value);
		} else if (in_array($value, ['(', ')'])) {
			return new Parenthesis($value);
		}
		throw new Exception('Undefined Value ' . $value);
	}

	abstract public function operate(Stack $stack);

	public function isOperator()
	{
		return false;
	}

	public function isParenthesis()
	{
		return false;
	}

	public function isNoOp()
	{
		return false;
	}

	public function render()
	{
		return $this->value;
	}
}
