<?php declare(strict_types = 1);

namespace Core\Model\Router;

use Nette\Http\IRequest;
use Nette\Http\UrlScript;

class RouteAdmin extends Route
{
	protected string $module = 'admin';

	public function setModule(string $module): self
	{
		$this->module = $module;

		return $this;
	}

	public function match(IRequest $httpRequest): ?array
	{
		$match = parent::match($httpRequest);

		if ($match && !str_contains((string) $match['presenter'], ':' . ucfirst($this->module) . ':')) {
			$name = explode(':', (string) $match['presenter']);
			array_splice($name, 1, 0, ucfirst($this->module));
			$match['presenter'] = implode(':', $name);
		}

		return $match;
	}

	public function constructUrl(array $params, UrlScript $refUrl): ?string
	{
		if (!str_contains((string) $params['presenter'], ':' . ucfirst($this->module) . ':')) {
			return null;
		}

		$url = parent::constructUrl($params, $refUrl);
		$url = str_replace('.' . strtolower($this->module), '', $url);

		return $url;
	}
}
