<?php declare(strict_types = 1);

namespace Core\Model\Templating;

class FileLoaderHelper
{
	protected array $latteWidgets = [];

	public static function parse(array $items): array
	{
		foreach ($items as $k => $v) {
			$items[$k] = self::parseOne($v);
		}

		return $items;
	}

	public static function parseOne(string $val): string
	{
		return str_replace('%appDir%', APP_DIR, $val);
	}

	public function addLatteWidgets(array $widgets): void
	{
		$this->latteWidgets += $widgets;
	}

	public function getLatteWidgets(): array
	{
		return $this->latteWidgets;
	}

	//	public function addLatteWidget(string $key, string $file): void
	//	{
	//		self::$latteWidgets[$key] = $file;
	//	}
	//
	//	public function getLatteWidgets(): array
	//	{
	//		return self::$latteWidgets;
	//	}
}
