<?php declare(strict_types = 1);

namespace Core\Model\Templating\Filters;

use Nette\Utils\Html;

class RemoveBlockElements
{
	public function __invoke(?string $text): Html
	{
		if (!$text) {
			return Html::el();
		}

		$text = preg_replace(
			'/<\/?(p|ul|li|div|dl|dt|ht|header|main|nav|ol|pre|section|table|h1|h2|h3|h4|h5|h6)>/i',
			'',
			$text,
		);

		return Html::el()->setHtml($text);
	}
}
