<?php declare(strict_types = 1);

namespace Core\Model\Templating;

use Contributte\Translation\Translator;
use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Entities\Variable;
use Core\Model\Helpers\VariableHelper;
use Nette\Caching\Cache;
use Nette\Caching\Storage;

class Variables
{
	public const cacheNamespace = 'coreVariables';

	protected VariableHelper         $variableHelper;
	protected EntityManagerDecorator $em;
	protected Translator             $translator;
	protected Storage                $storage;

	protected ?array $variables = null;

	public function __construct(
		VariableHelper         $variableHelper,
		EntityManagerDecorator $em,
		Translator             $translator,
		Storage                $storage
	)
	{
		$this->variableHelper = $variableHelper;
		$this->em             = $em;
		$this->translator     = $translator;
		$this->storage        = $storage;
	}

	public function replaceVariables(string $content): string
	{
		if (!empty($this->getVariables())) {
			return strtr($content, $this->getVariables());
		}

		return $content;
	}

	protected function getVariables(): array
	{
		if ($this->variables === null) {
			$cache = new Cache($this->storage, self::cacheNamespace);

			$this->variables = $cache->load(self::cacheNamespace, function(&$dep) {
				$dep = [
					Cache::EXPIRATION => '1 week',
				];

				$data = [];
				foreach ($this->em->createQueryBuilder()
					         ->from(Variable::class, 'v')
					         ->select('v.key, v.value')
					         ->where('v.lang = :lang')
					         ->setParameter('lang', $this->translator->getLocale())
					         ->getQuery()->getArrayResult() as $row) {
					$data['[[' . $row['key'] . ']]'] = $this->variableHelper->formatValue((string) $row['value']);
				}

				return $data;
			});
		}

		return $this->variables;
	}
}
