<?php declare(strict_types = 1);

namespace Core\Model\Translation;

use DeepL\Translator;

class DeepLApi
{
	protected string $authKey;
	protected array  $locales = [
		'cs' => 'cs',
		'en' => 'en-GB',
		'es' => 'es',
		'uk' => 'uk',
	];

	public function __construct(
		string $authKey
	)
	{
		$this->authKey = $authKey;
	}

	public function translateText(string $str, string $sourceLang, string $targetLang): string
	{
		$translator = new Translator($this->authKey);

		$data = $translator->translateText($str, $this->locales[$sourceLang], $this->locales[$targetLang], []);

		return $data->text;
	}

	public function translateHtml(string $html, string $sourceLang, string $targetLang): string
	{
		$translator = new Translator($this->authKey);

		$data = $translator->translateText($html, $this->locales[$sourceLang], $this->locales[$targetLang], [
			'tag_handling' => 'html',
		]);

		return $data->text;
	}
}
