<?php declare(strict_types = 1);

namespace Core\Model\Translation;

use Tracy\Debugger;

class TextTranslator
{
	protected DeepLApi $deepLApi;

	public function __construct(
		DeepLApi $deepLApi
	)
	{
		$this->deepLApi = $deepLApi;
	}

	public function translateText(string $text, string $sourceLang, string $targetLang): ?string
	{
		try {
			return $this->deepLApi->translateHtml($text, $sourceLang, $targetLang);
		} catch (\Exception $e) {
			Debugger::log($e, 'translateText');
		}

		return null;
	}

	public function translateHtml(string $text, string $sourceLang, string $targetLang): ?string
	{
		try {
			return $this->deepLApi->translateHtml($text, $sourceLang, $targetLang);
		} catch (\Exception $e) {
			Debugger::log($e, 'translateHtml');
		}

		return null;
	}
}
