<?php declare(strict_types = 1);

namespace Core\Model\Translation\Utils;

use Core\Model\SystemConfig;
use function str_contains;
use function str_starts_with;

class Helpers
{
	/**
	 * @param array|null $rules
	 */
	public static function isDomainAllowed(string $domain, array $rules = null): bool
	{
		$rules ??= SystemConfig::load('staticTextsTranslation.domains');

		foreach ($rules as $key => $all) {
			switch ($key) {
				case 'startsWith':
					foreach ($all as $needle) {
						if (str_starts_with($domain, (string) $needle)) {
							return true;
						}
					}
					break;
				case 'contains':
					foreach ($all as $needle) {
						if (str_contains($domain, (string) $needle)) {
							return true;
						}
					}
					break;
			}
		}

		return false;
	}
}
