<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\Helpers\Strings;
use Core\Model\UI\Form\BaseForm;
use Core\Model\UI\Form\Traits\ChoiceInputTrait;
use Core\Model\UI\Form\Traits\TInputExtend;
use Nette\Forms\Controls\CheckboxList;
use Nette\Utils\Html;

/**
 * @method BaseForm getForm(bool $throw = true)
 */
class CheckboxListInput extends CheckboxList
{
	use ChoiceInputTrait;
	use TInputExtend;

	protected array $eInputs = [];

	public function getControl(): Html
	{
		parent::getControl();
		$fieldset = Html::el('fieldset', [
			'disabled' => $this->isControlDisabled(),
		]);

		foreach ($this->items as $value => $caption) {
			$line = CheckboxInput::makeCheckbox(
				$this->getHtmlName(),
				$caption,
				$this->isValueSelected($value),
				$value,
				false,
				$this->isValueDisabled($value),
				$this->getHtmlId((string) $value),
			);
			$line = Html::el('div class="form-control form-control-check"')->setHtml($line);

			$fieldset->addHtml($line)
				->addClass('checkbox-list-input');
		}

		return $fieldset;
	}

	public function getElementInputs(): array
	{
		if (!$this->eInputs) {
			parent::getControl();

			foreach ($this->items as $value => $caption) {
				$input                   = CheckboxInput::makeCheckbox(
					$this->getHtmlName(),
					$this->translate($caption),
					$this->isValueSelected($value),
					$value,
					false,
					$this->isValueDisabled($value),
					$this->getHtmlId((string) $value),
				);
				$input                   = Html::el('div class="form-control form-control-check"')->setHtml($input);
				$this->eInputs[$caption] = $input;
			}
		}

		return $this->eInputs;
	}

	public function getHtmlId(string $value = ''): string
	{
		return parent::getHtmlId() . ($value ? '-' . Strings::webalize((string) $value) : '');
	}

	public function getValue(): array
	{
		if ($this->getIsMultiLanguage()) {
			foreach ($this->value as $lang => $val) {
				if (!array_key_exists($val, $this->items)) {
					$this->value[$lang] = null;
				}
			}

			return $this->value ?: [];
		}

		return array_values(array_intersect((array) $this->value, array_keys($this->items)) ?: []) ?: [];
	}

	/**
	 * @inheritDoc
	 */
	public function setDisabled($value = true)
	{
		if (!is_array($value)) {
			return parent::setDisabled($value);
		}

		parent::setDisabled(false);
		$this->disabled = (bool) array_fill_keys($value, true);
		$this->value    = $this->value ? array_diff($this->value, $value) : $this->value;

		return $this;
	}

}
