<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\AbstractPresenter;
use Nette;
use Nette\Utils\Html;

class TagsInput extends TextInput
{
	protected array $values = [];

	/** @var callable|null */
	protected $callback = null;

	/** @var callable|null */
	protected $createCallback = null;

	public function __construct(
		string    $label = null,
		?callable $callback = null,
		?callable $createCallback = null,
	)
	{
		parent::__construct($label);
		$this->setCallback($callback);
		$this->setCreateCallback($createCallback);

		$this->monitor(AbstractPresenter::class, function(AbstractPresenter $presenter) {
			$this->control->{'data-typeahead-url'} = $this->callback;
			$this->control->{'data-create-url'}    = $this->createCallback;
		});
	}

	public function getControl(): Html
	{
		$control = parent::getControl();
		$control->addClass('form-control form-control-lg');
		$control->attrs += [
			'data-role'     => 'tagsinput',
			'data-defaults' => Nette\Utils\Json::encode($this->values),
		];
		if (!empty($this->placeholder)) {
			$control->setAttribute('placeholder', $this->placeholder);
		}

		return $control;
	}

	public function setCallback(?callable $callback = null): void
	{
		$this->callback = $callback;
	}

	public function setCreateCallback(?callable $callback = null): void
	{
		$this->createCallback = $callback;
	}

	/**
	 * @param array $values
	 */
	public function setDefaultValue($values): self
	{
		$form = $this->getForm(false);
		if ($this->isDisabled() || !$form || !$form->isAnchored() || !$form->isSubmitted()) {
			$this->values = $values;
			$this->setValue(implode(',', array_map(fn($v) => $v['key'], $values)));
		}

		return $this;
	}

}
