<?php declare(strict_types = 1);

namespace Core\Model\UI;

use Core\Model\Dao\Site;
use Core\Model\Helpers\Strings;
use Core\Model\Module;
use Core\Model\Parameters;
use Core\Model\Templating\FileLoaderHelper;

trait TUITemplate
{

	public function formatTemplateFiles(): array
	{
		$list = [];

		$path = explode(':', $this->getName());

		if (count($path) > 2) {
			$tmp     = $path[1];
			$path[1] = $path[0];
			$path[0] = $tmp;
		}

		if ($path[0] === 'Error') {
			unset($path[1]);
		}

		//TODO možnost měnit šablonu
		$module     = array_shift($path);
		$pathString = implode(DIRECTORY_SEPARATOR, $path);

		$list[] = Strings::joinPaths(
				TEMPLATES_DIR,
				$module,
				$this->template->currentSite->getIdent(),
				'default',
				$pathString,
				$this->view,
			) . '.latte';
		$list[] = Strings::joinPaths(TEMPLATES_DIR, $module, 'default', $pathString, $this->view) . '.latte';

		if (Module::isFront()) {
			/** @var FrontPresenter $presenter */
			$presenter = $this;

			if (property_exists($presenter, 'sitesService')) {
				/** @var Site $site */
				$site          = $presenter->sitesService->getCurrentSite();
				$baseLayoutKey = $site->layoutKey;

				if ($baseLayoutKey) {
					$baseDir = FileLoaderHelper::parseOne(Parameters::load('system.baseTemplates.' . $baseLayoutKey));
					$list[]  = Strings::joinPaths($baseDir, $pathString, $this->view) . '.latte';
				}
			}
		}

		$dirName = dirname((string) $this->getReflection()->getFileName());
		if ($dirName) {
			$list[] = Strings::joinPaths(
					$dirName,
					'../Templates/',
					ucfirst((string) end($path)),
					$this->view,
				) . '.latte';
		}

		$parentReflection = $this->getReflection()->getParentClass();
		if ($parentReflection) {
			$dirName = dirname((string) $parentReflection->getFileName());
			if ($dirName) {
				$list[] = Strings::joinPaths(
						$dirName,
						'../Templates',
						ucfirst((string) end($path)),
						$this->view,
					) . '.latte';
			}
		}

		return $list;
	}

	public function formatLayoutTemplateFiles(): array
	{
		if ($this->layout) {
			return [(string) $this->layout];
		}

		$list = [];

		$path = explode(':', $this->getName());

		if (count($path) > 2) {
			$tmp     = $path[1];
			$path[1] = $path[0];
			$path[0] = $tmp;
		}

		$module = array_shift($path);
		$action = (string) end($path);

		//TODO možnost měnit šablonu
		do {
			$pathString = implode(DIRECTORY_SEPARATOR, $path);
			$list[]     = Strings::joinPaths(
				TEMPLATES_DIR,
				$module,
				$this->template->currentSite->getIdent(),
				$pathString,
				'@layout.latte',
			);
			$list[]     = Strings::joinPaths(TEMPLATES_DIR, $module, 'default', $pathString, '@layout.latte');
		} while (array_pop($path));

		$dirName = dirname((string) $this->getReflection()->getFileName());
		if ($dirName) {
			$list[] = Strings::joinPaths($dirName, '../Templates', $action, '@layout.latte');
			$list[] = Strings::joinPaths($dirName, '../Templates/@layout.latte');
			$list[] = Strings::joinPaths(SRC_DIR, 'core/src/AdminModule/Templates/@layout.latte');
		}

		return $list;
	}
}
