<?php declare(strict_types = 1);

namespace Core\Model\UI\Traits;

use Core\Model\Event\ControlEvent;
use Core\Model\Providers\BaseComponentPack;
use Nette\ComponentModel\IComponent;

trait TPresenterComponentPack
{
	/** @var IComponent[][] */
	protected array $componentsPack = [
		'headStart' => [],
		'head'      => [],
		'bodyStart' => [],
		'bodyEnd'   => [],
	];

	protected function tryCall(string $method, array $params): bool
	{
		$result = parent::tryCall($method, $params);

		if (str_starts_with($method, 'render')) {
			$this->template->componentsPack = $this->componentsPack;
		}

		return $result;
	}

	public function addHeadStartComponent(IComponent $component, ?string $name): void
	{
		$this->addToComponentsPack($component, 'headStart', $name);
	}

	public function addHeadComponent(IComponent $component, ?string $name): void
	{
		$this->addToComponentsPack($component, 'head', $name);
	}

	public function addBodyStartComponent(IComponent $component, ?string $name): void
	{
		$this->addToComponentsPack($component, 'bodyStart', $name);
	}

	public function addBodyEndComponent(IComponent $component, ?string $name): void
	{
		$this->addToComponentsPack($component, 'bodyEnd', $name);
	}

	protected function addToComponentsPack(IComponent $component, string $position, ?string $name): void
	{
		$name = $name ?: $component->getName();

		if ($component instanceof BaseComponentPack && !$component->getRenderFile()) {
			$component->setRenderFile($position);
		}


		if (!$this->getComponent($name . '_' . $position, false)) {
			$this->addComponent($component, $name . '_' . $position);
			$this->componentsPack[$position][$name] = $component;
		}
	}

	public function getBodyEndComponentsPack(): array
	{
		$this->eventDispatcher->dispatch(new ControlEvent($this), self::class . '::getBodyEndComponentsPack');

		return $this->componentsPack['bodyEnd'];
	}

	public function getComponentsPack(): array
	{
		return $this->componentsPack;
	}
}
