<?php declare(strict_types = 1);

namespace Core\Model;

use Core\Model\Helpers\Strings;

class WebColors
{
	public function __construct(protected Settings $settings)
	{
	}

	public function clearCache(): void
	{
		$this->settings->clearCache();
	}

	public function getColors(string $siteIdent = ''): array
	{
		$siteIdent = $siteIdent === '' ? $siteIdent : $siteIdent . '_';

		$baseLayout = $this->settings->get($siteIdent . 'baseLayout', '', false);

		if ($baseLayout) {
			return $this->settings->getPrefixed($siteIdent . 'webColors' . Strings::firstUpper($baseLayout)) ?: [];
		}

		return $this->settings->getPrefixed($siteIdent . 'webColors') ?: [];
	}
}
