import SimpleBar from 'simplebar';
import naja from "naja";
import {Utilities} from "core/front/src/js/utils/utilities";

naja.historyHandler.uiCache = false;
naja.history = false;
naja.uiHandler.selector = '';
// window.naja = naja;

// TODO staré řešení JS volá metodu v ajaxComplete. Při předělávání nezapomenou se napojit na najaComplete
window.fileRequest = (fileRequests) => {
	if (fileRequests === undefined)
		return;

	for (let i in fileRequests) {
		window.open(fileRequests[i].url, fileRequests[i].name);
	}
};

document.addEventListener('DOMContentLoaded', () => {
	document.querySelectorAll('[data-simplebar]').forEach(el => {
		new SimpleBar(el);
	});

	initBoolSwitcherControl();

	// Kvůli kompatibilitě s jquery
	window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
		initBoolSwitcherControl();
	});

	naja.addEventListener('complete', e => {
		initBoolSwitcherControl();
	});
});

// bool switcher
const initBoolSwitcherControl = () => {
	document.querySelectorAll('.bool-switcher-control label:not(.init)').forEach(label => {
		label.classList.add('init');
		label.addEventListener('click', e => {
			let siblings = Utilities.getSiblings(label);

			siblings.forEach(sib => {
				sib.setAttribute('class', 'btn btn-outline-' + sib.dataset.btnClass);
			});

			label.setAttribute('class', 'btn btn-' + label.dataset.btnClass);
		});
	});
};

