function closeModal(element) {
	var el = document.getElementById(element);
	var new_el = el.cloneNode(true);
	el.parentNode.replaceChild(new_el, el);

	$('.modal.show').last().modal('hide');
}

jQuery(function ($) {
	$(document).ready(function () {
		/************************
		 * ====   Datetime picker
		 */
		initDatePickers();
		$(document).ajaxComplete(function (event, request, settings) {
			initDatePickers();
		});


		/************************
		 * ====   Tagsinput
		 */
		initTagsInput();
		// $("input[data-role=tagsinput], select[multiple][data-role=tagsinput]")

	});
});

var typeHeadVars = [];

function initDatePickers() {
	$('input[type="date"]:not(.date), input[data-provide="datepicker"]').addClass('date');
	$('input[type="datetime-local"]:not(.datetime-local)').addClass('datetime-local');

	$('input.date, input.datetime-local').each(function (i, el) {
		el = $(el);
		var isDate = el.is('.date') || el.is('[type="date"]');

		var value = el.val();
		el.get(0).type = 'text';
		el.val(value);

		el.datetimepicker({
			startDate: el.attr('min'),
			endDate: el.attr('max'),
			weekStart: 1,
			minView: isDate ? 'month' : 'hour',
			format: isDate ? 'd. m. yyyy' : 'd. m. yyyy - hh:ii',
			autoclose: true,
			language: 'cs',
			fontAwesome: true
		});
		el.attr('value') && el.datetimepicker('setValue');
	});
}

function initTagsInput() {
	$("input[data-role=tagsinput], select[multiple][data-role=tagsinput]").each(function () {
		var $this = $(this),
			name = $(this).attr('id'),
			tpKey = $(this).attr('data-typehead-key') !== undefined ? $(this).attr('data-typehead-key') : name,
			typeheaderUrl = $this.attr('data-typeahead-url'),
			createUrl = $this.attr('data-create-url');

		if ($this.hasClass('initialized'))
			return true;
		$this.addClass('initialized');

		if (typeHeadVars['tp' + tpKey] === undefined) {
			typeHeadVars['tp' + tpKey] = new Bloodhound({
				// local: [{key: '123', value:'test'}],
				datumTokenizer: Bloodhound.tokenizers.obj.whitespace('value'),
				queryTokenizer: Bloodhound.tokenizers.whitespace,
				prefetch: {
					url: typeheaderUrl,
					// filter: function (data) {
					// 	return $.map(data, function(crop) {
					// 		return {
					// 			value: crop.Name
					// 		};
					// 	});
					// }
				}
				// remote: {
				// 	url: '_',
				// 	replace: function (url, query) {
				// 		return typeheaderUrl.replace('__q__', query);
				// 	}
				// }
			});
			typeHeadVars['tp' + tpKey].initialize();
		}

		$this.tagsinput({
			trimValue: true,
			itemValue: 'key',
			itemText: 'value',
			freeInput: true,
			typeaheadjs: {
				name: 'tp' + tpKey,
				displayKey: 'value',
				source: typeHeadVars['tp' + tpKey].ttAdapter(),
			},
		});

		$.each(JSON.parse($this.attr('data-defaults')), function (i, obj) {
			$this.tagsinput('add', {key: obj.key, value: obj.value}, {preventPost: true});
		});

		$this.on('beforeItemAdd', function (e) {
			var item = e.item;

			if (!e.options || !e.options.preventPost) {
				if (item == undefined || item.value == undefined) {
					e.cancel = true;
				} else if (item.key == item.value) {
					e.cancel = true;
					$.nette.ajax({
						url: createUrl.replace('__value__', item.value),
						success: function (response) {
							$this.tagsinput('add', {key: response, value: item.value});
						}
					});
				}
			}
		});
	});
}
