<?php

namespace Core\Model\Entities\Repository;

trait TKdybyRepository
{
	/**
	 * Fetches all records like $key => $value pairs
	 *
	 * @param array        $criteria parameter can be skipped
	 * @param string       $value    mandatory
	 * @param array|string $orderBy  parameter can be skipped
	 * @param string       $key      optional
	 *
	 * @throws QueryException
	 * @return array
	 */
	public function findPairs($criteria, $value = null, $orderBy = [], $key = null)
	{
		if (!is_array($criteria)) {
			$key      = $orderBy;
			$orderBy  = $value;
			$value    = $criteria;
			$criteria = [];
		}

		if (!is_array($orderBy)) {
			$key     = $orderBy;
			$orderBy = [];
		}

		if (empty($key)) {
			$key = $this->getClassMetadata()->getSingleIdentifierFieldName();
		}

		/** @var \Kdyby\Doctrine\QueryBuilder $qb */
		$qb    = $this->createQueryBuilder('e')
			->whereCriteria($criteria)
			->select(["e.$value", "e.$key"])
			->resetDQLPart('from')->from($this->getEntityName(), 'e', 'e.' . $key);
		$query = $qb->autoJoinOrderBy($orderBy)->getQuery();

		try {
			return array_map(function($row) {
				return reset($row);
			}, $query->getResult(AbstractQuery::HYDRATE_ARRAY));
		} catch (\Exception $e) {
			throw $this->handleException($e, $query);
		}
	}

	/**
	 * Fetches all records and returns an associative array indexed by key
	 *
	 * @param array  $criteria
	 * @param string $key
	 *
	 * @throws \Exception|QueryException
	 * @return array
	 */
	public function findAssoc($criteria, $key = null)
	{
		if (!is_array($criteria)) {
			$key      = $criteria;
			$criteria = [];
		}

		$query = $this->createQueryBuilder('e')
			->whereCriteria($criteria)
			->resetDQLPart('from')->from($this->getEntityName(), 'e', 'e.' . $key)
			->getQuery();

		try {
			return $query->getResult();
		} catch (\Exception $e) {
			throw $this->handleException($e, $query);
		}
	}

	/**
	 * @param integer|array $id
	 *
	 * @return \Doctrine\ORM\Proxy\Proxy|null
	 */
	public function getReference($id)
	{
		/** @var \Doctrine\ORM\Proxy\Proxy|null $reference */
		$reference = $this->getEntityManager()->getReference($this->_entityName, $id);
		return $reference;
	}
}