import SimpleBar from 'simplebar';
import naja from "naja";
import {Utilities} from "core/front/src/js/utils/utilities";
import Pickr from "@simonwep/pickr";
import NestedLists from './utils/NestedLists';
import SortableLists from './utils/SortableLists';
import NavTabs from './utils/NavTabs';
import "tablesaw/dist/tablesaw.jquery";


naja.historyHandler.uiCache = false;
naja.history = false;
naja.uiHandler.selector = '';

window.naja = naja;
global.naja = window.naja;

/**
 * Interakce / responzivita
 */

document.addEventListener('DOMContentLoaded', () => {

	const hamburger = document.querySelector('.navbar__hamburger');
	const sideBar = document.querySelector('.sidebar');

	hamburger.addEventListener('click', () => {
		if (hamburger.classList.contains('navbar__hamburger--active')) {
			hamburger.classList.remove('navbar__hamburger--active');
			sideBar.classList.remove('sidebar--active');
		} else {
			hamburger.classList.add('navbar__hamburger--active');
			sideBar.classList.add('sidebar--active');
		}
	});

	document.querySelectorAll('table').forEach(el => {
		el.classList.add('tablesaw');
		el.classList.add('tablesaw-stack');
		el.setAttribute('data-tablesaw-mode', 'stack');
	});

	Tablesaw.init();

	document.querySelectorAll('[data-show-filters]').forEach(el => {
		el.addEventListener('click', () => {
			const filters = el.parentNode.parentNode.querySelector('.tr-filters');
			Utilities.toggleClass(filters, 'active');
			Utilities.toggleClass(el, 'active');
		})
	});

});

// Kousky CK editoru před kompletní změnou
document.ckEditorExtraPlugins =
	'panelbutton,button,floatpanel,panel,justify,colorbutton,font,filemanager,lineheight,readmore,wordcount';

// TODO staré řešení JS volá metodu v ajaxComplete. Při předělávání nezapomenou se napojit na najaComplete
window.fileRequest = (fileRequests) => {
	if (fileRequests === undefined)
		return;

	for (let i in fileRequests) {
		window.open(fileRequests[i].url, fileRequests[i].name);
	}
};

global.naja.addEventListener('before', e => {
	let loadingOverlay = document.getElementById('loading-overlay');

	if (loadingOverlay !== null) {
		loadingOverlay.dataset.count = parseInt(loadingOverlay.dataset.count) + 1;
	} else {
		document.getElementsByTagName('BODY')[0].insertAdjacentHTML('beforeend', '<div id="loading-overlay" data-count="1">' +
			'<div class="spinner">' +
			'<div class="rect1"></div>' +
			'<div class="rect2"></div>' +
			'<div class="rect3"></div>' +
			'<div class="rect4"></div>' +
			'<div class="rect5"></div>' +
			'</div></div>');
	}
});

global.naja.addEventListener('complete', e => {
	let loadingOverlay = document.getElementById('loading-overlay');

	if (loadingOverlay) {
		if (loadingOverlay.dataset.count > 1)
			loadingOverlay.dataset.count = parseInt(loadingOverlay.dataset.count) - 1;
		else
			loadingOverlay.parentNode.removeChild(loadingOverlay);
	}
});

document.addEventListener('DOMContentLoaded', () => {
	const nestedLists = new NestedLists;
	const sortableLists = new SortableLists;
	const navTabs = new NavTabs;

	document.querySelectorAll('[data-simplebar]').forEach(el => {
		new SimpleBar(el);
	});

	setSiteSelectByActiveTab();
	initBoolSwitcherControl();
	initDataTextToggle();
	initDataGridNestedListChange();
	initColorPicker();
	checkSwitchesHighlight();
	initDataLinkOnChange();
	initSwitchContentLang();

	// Kvůli kompatibilitě s jquery
	window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
		nestedLists.init();
		sortableLists.init();
		navTabs.init();
		initBoolSwitcherControl();
		initDataTextToggle();
		initDataGridNestedListChange();
		initColorPicker();
		checkSwitchesHighlight();
		setSiteSelectByActiveTab();
		initDataLinkOnChange();
		initSwitchContentLang();
	});

	global.naja.addEventListener('complete', e => {
		nestedLists.init();
		sortableLists.init();
		navTabs.init();
		initBoolSwitcherControl();
		initDataTextToggle();
		initDataGridNestedListChange();
		initColorPicker();
		checkSwitchesHighlight();
		setSiteSelectByActiveTab();
		initDataLinkOnChange();
		initSwitchContentLang();
	});

	document.addEventListener('shownBsModal', e => {
		checkSwitchesHighlight();
	});

	document.addEventListener('click', e => {
		let target = e.target;

		/**
		 * Přepínač addBool
		 */
		if (target.classList.contains('switch__input')) {
			switchHighlightValue(target.parentElement);
		}
	});
});

const setSiteSelectByActiveTab = () => {
	let activeSite = document.querySelector('.tab-content__panel.active');
	if (activeSite) {
		activeSite = activeSite.dataset.site;

		if (!activeSite)
			return;

		document.querySelectorAll('[name="site"]:not([data-changed-by-tab])').forEach(input => {
			input.setAttribute('data-changed-by-tab', true);

			if (input.value == activeSite)
				return;

			setTimeout(() => {
				input.value = activeSite;
				input.dispatchEvent(new Event('change', {
					bubbles: true,
				}));
			}, 300);
		});
	}
}

const checkSwitchesHighlight = () => {
	document.querySelectorAll('.switch').forEach(switcher => {
		switchHighlightValue(switcher);
	});
}

// Přepínač addBool - zvýraznění zvolené hodnoty
const switchHighlightValue = (switcher) => {
	let switcherLeftOffset = switcher.getBoundingClientRect().left;

	if (switcher.classList.contains('switch--bool')) {
		let input = switcher.querySelector('input');
		let boolWatchers = document.querySelectorAll('[data-watch-bool-input="' + input.id + '"]');
		let checked = input.checked;
		let itemSuccess = switcher.querySelector('.switch__item-1');
		let itemDanger = switcher.querySelector('.switch__item-0');

		if (checked) {
			itemSuccess.classList.remove('bg-danger');
			itemDanger.classList.add('bg-success');

			boolWatchers.forEach(watcher => {
				watcher.classList.add('bg-success');
				watcher.classList.remove('bg-danger');
			})
		} else {
			itemDanger.classList.remove('bg-success');
			itemSuccess.classList.add('bg-danger');

			boolWatchers.forEach(watcher => {
				watcher.classList.remove('bg-success');
				watcher.classList.add('bg-danger');
			})
		}

		return;
	}

	let checked = switcher.querySelector('input:checked');

	checked = checked ? checked.nextElementSibling : null;

	if (checked) {
		let slide = switcher.querySelector('.switch__slide');

		slide.classList.remove('bg-' + slide.dataset.bg);
		slide.classList.add('bg-' + checked.dataset.bg);
		slide.dataset.bg = checked.dataset.bg;
		slide.style.left = (checked.getBoundingClientRect().left - switcherLeftOffset + 2) + 'px';
		slide.style.width = (checked.offsetWidth - 4) + 'px';
	}
}

// bool switcher
const initBoolSwitcherControl = () => {
	document.querySelectorAll('.bool-switcher-control label:not(.init)').forEach(label => {
		label.classList.add('init');
		label.addEventListener('click', e => {
			let siblings = Utilities.getSiblings(label);

			siblings.forEach(sib => {
				sib.setAttribute('class', 'btn btn-outline-' + sib.dataset.btnClass);
			});

			label.setAttribute('class', 'btn btn-' + label.dataset.btnClass);
		});
	});
};

const initDataTextToggle = () => {
	document.querySelectorAll('[data-text-toggle]:not(.init)').forEach(el => {
		el.classList.add('init');
		el.addEventListener('click', e => {
			let tmp = el.textContent.trim();

			el.textContent = el.dataset.textToggle.trim();
			el.dataset.textToggle = tmp;
		});
	});
};

const initDataGridNestedListChange = () => {
	document.querySelectorAll('.datagrid .nested-list input:not(.init)').forEach(input => {
		input.classList.add('init');

		input.addEventListener('change', e => {
			global.naja.uiHandler.submitForm(input.form);
		});
	});
};

// Init color pickeru
const initColorPicker = () => {
	document.querySelectorAll('[data-color-input="wrap"]:not(.init)').forEach(wrap => {
		wrap.classList.add('init');
		let input = wrap.querySelector('[data-color-input="input"]');

		let pickr = Pickr.create({
			el: wrap.querySelector('[data-color-input="btn"]'),
			theme: 'classic',
			default: input.value || '#2AABE2',
			swatches: [
				'#4c99ca',
				'#f5b252',
				'#30e4ef',
				'#4c4949',
				'#ff0000',
				'#f6f6f6',
				'#a1a1a1',
				'#cacaca',
				'#464444',
				'#39b54a',
				'#dadee0',
				'#8f8b8b',
			],
			components: {
				preview: true,
				opacity: true,
				hue: true,
				interaction: {
					hex: true,
					rgba: true,
					hsla: true,
					hsva: false,
					cmyk: false,
					input: true,
					clear: true,
					save: true
				}
			},
			strings: {
				save: wrap.dataset.colorPickerTextSave,
				clear: wrap.dataset.colorPickerTextClear,
			}
		}).on('save', (color, instance) => {
			input.value = color ? color.toHEXA().toString() : '';
			instance.hide();
		});

		input.addEventListener('focus', e => {
			input.blur();
			pickr.show();
			setTimeout(() => {
				pickr.getRoot().interaction.result.focus();
			}, 200);
		});
	});
};

const initDataLinkOnChange = () => {
	document.querySelectorAll('[data-link-on-change]:not(.init)').forEach(el => {
		el.classList.add('init');
		el.addEventListener('change', e => {
			e.preventDefault();
			e.stopPropagation();

			const link = el.dataset.linkOnChange.replace('__val__', el.value);

			global.naja.makeRequest('post', link, {}, {
				history: false,
			});
		});
	});
};

const initSwitchContentLang = () => {
	if (document.querySelectorAll('.content-lang-switcher').length > 0) {
		let lang = document.querySelector('[name="selectedContentLang"]:checked').value;
		if (lang === undefined) {
			lang = document.querySelector('html').getAttribute('lang');
			document.querySelectorAll(`.content-lang-switcher input[value="'${lang}'"]`).forEach(el => el.click());
		} else {
			if (typeof (CKEDITOR) !== "undefined") {
				CKEDITOR.on('instanceReady', function () {
					switchContentLang(lang);
				});
			} else {
				switchContentLang(lang);
			}
		}

		document.querySelectorAll('[name="selectedContentLang"]').forEach(el => {
			el.addEventListener('change', e => {
				if (el.checked)
					switchContentLang(el.value);
			})
		});
	}
};

const switchContentLang = (lang) => {
	Cookies.set('contentLang', lang);

	document.querySelectorAll('[data-content-lang]').forEach(el => {
		const isEditor = el.nextElementSibling ? el.nextElementSibling.classList.contains('cke') : false;
		if (el.dataset.contentLang != lang) {
			if (isEditor) {
				el.nextElementSibling.style.display = 'none';
			} else {
				el.style.display = 'none';
			}
		} else {
			if (isEditor) {
				el.nextElementSibling.style.display = 'block';
			} else {
				el.style.display = 'block';
			}
		}
	});
};
