<?php declare(strict_types = 1);

namespace Core\ErrorModule\Presenters;

use Nette;
use Nette\Application\IResponse;
use Nette\Application\Request;
use Nette\Application\Responses;
use Nette\SmartObject;
use Tracy\ILogger;

class ErrorPresenter extends BasePresenter
{
	use SmartObject;

	/** @var ILogger */
	private $logger;

	public function __construct(ILogger $logger)
	{
		$this->logger = $logger;
	}

	/**
	 * @return IResponse
	 */
	public function run(Request $request): IResponse
	{
		$e = $request->getParameter('exception');

		//TODO FIX
		$file = __DIR__ . '/../templates/Error/500.phtml';

		try {
			$this->logger->log("HTTP code {$e->getCode()}: {$e->getMessage()} in {$e->getFile()}:{$e->getLine()}", 'access');
			[$module, $presenter, $sep] = Nette\Application\Helpers::splitName($request->getPresenterName());
			$errorPresenter = $module . $sep . 'Error4xx';

			return new Responses\ForwardResponse($request->setPresenterName($errorPresenter));
		} catch (\Exception $e) {
			if (file_exists(TEMPLATES_DIR . '/Error/500.phtml'))
				$file = TEMPLATES_DIR . '/Error/500.phtml';
			else
				$file = __DIR__ . '/../templates/Error/500.phtml';//TODO FIX

			$this->logger->log($e, ILogger::EXCEPTION);
		}

		return new Responses\CallbackResponse(function() use ($file) {
			require $file;
		});
	}
}
