<?php declare(strict_types = 1);

namespace Core\FrontModule\Model\Templating;

use Core\Model\Event\TemplateFactoryEvent;
use Nette\Application\UI;

final class TemplateFactory extends \Core\Model\Templating\TemplateFactory
{
	public function createTemplate(UI\Control $control = null): UI\ITemplate
	{
		$template = parent::createTemplate($control);

		$this->eventDispatcher->dispatch(new TemplateFactoryEvent($template), 'templateFactory::createTemplate');

		return $template;
	}
}
