<?php declare(strict_types = 1);

namespace Core\Model\Event;

use Symfony\Contracts\EventDispatcher\Event;

class TtSearchEvent extends Event
{
	/** @var string */
	public $q;

	/** @var array */
	public $inputs;

	/** @var array */
	public $values;

	/** @var array */
	protected $result = [];

	public function __construct(string $q, array $inputs, array $values)
	{
		$this->q      = $q;
		$this->inputs = $inputs;
		$this->values = $values;
	}

	public function addResult(string $type, $data): self
	{
		$this->result[$type] = $data;

		return $this;
	}

	public function getResult(): array { return $this->result; }
}
