<?php declare(strict_types = 1);

namespace Core\Model\Notifiers\MailNotifiers;

use Core\Model\Entities\Site;
use Core\Model\Notifiers\ILogNotifier;
use Nette\Mail\Message;
use Nette\Mail\SendmailMailer;

class LogNotifier implements ILogNotifier
{
	/** @var string */
	public static $developersMail;

	/** @var callable */
	public static $getUserEmails;

	/** @var Site */
	public static $site;

	/**
	 * @param string $subject
	 * @param string $message
	 */
	public static function toDevelopers(string $message, string $subject): void
	{
		$msg = new Message;
		$msg->setFrom(sprintf('%s <%s>', static::$site->siteName, static::$developersMail))
			->addTo(static::$developersMail)
			->setSubject($subject)
			->setHtmlBody($msg);

		(new SendmailMailer)->send($msg);
	}

	/**
	 * @param string $message
	 * @param string $subject
	 */
	public static function toCustomer(string $message, string $subject): void
	{
		$msg = new Message;
		$msg->setFrom(sprintf('%s <%s>', static::$site->siteName, static::$site->email))
			->setSubject($subject)
			->setHtmlBody($message);

		foreach (call_user_func(static::$getUserEmails) as $email) {
			$msg->addTo($email);
		}

		(new SendmailMailer)->send($msg);
	}

}
