<?php declare(strict_types = 1);

namespace Core\Model\Templating;

use Core\Model\Event\EventDispatcher;
use Core\Model\Images\ImagePipe;
use Core\Model\Lang\Langs;
use Core\Model\Settings;
use Core\Model\Sites;
use Core\Model\WebColors;
use Nette;
use Nette\Application\LinkGenerator;
use Nette\Application\UI;
use Nette\Bridges\ApplicationLatte\ILatteFactory;
use Nette\Caching\IStorage;
use Nette\Http\IRequest;
use Nette\Localization\ITranslator;
use Nette\Security\User;

class TemplateFactory extends Nette\Bridges\ApplicationLatte\TemplateFactory
{
	protected array $support;

	protected Langs $langs;

	protected ImagePipe $imagePipe;

	protected LinkGenerator $linkGenerator;

	protected Settings $settings;

	protected Sites $sites;

	protected ITranslator $translator;

	protected WebColors $webColors;

	protected EventDispatcher $eventDispatcher;

	public function __construct(array $support, ImagePipe $imagePipe, LinkGenerator $linkGenerator, Settings $settings, Langs $langs,
	                            Sites $sites, ITranslator $translator, WebColors $webColors, EventDispatcher $eventDispatcher,
	                            ILatteFactory $latteFactory, IRequest $httpRequest = null, User $user = null, IStorage $cacheStorage = null, $templateClass = null
	)
	{
		parent::__construct($latteFactory, $httpRequest, $user, $cacheStorage, $templateClass);

		$this->support         = $support;
		$this->imagePipe       = $imagePipe;
		$this->linkGenerator   = $linkGenerator;
		$this->settings        = $settings;
		$this->langs           = $langs;
		$this->translator      = $translator;
		$this->sites           = $sites;
		$this->webColors       = $webColors;
		$this->eventDispatcher = $eventDispatcher;
	}

	public function createTemplate(UI\Control $control = null): UI\ITemplate
	{
		$template = parent::createTemplate($control);

		$site = $this->sites->getCurrentSite();

		$template->_imagePipe     = $this->imagePipe;
		$template->linkGenerator  = $this->linkGenerator;
		$template->support        = $this->support;
		$template->currentSite    = $site;
		$template->siteName       = $site->getSiteName();
		$template->adminAssets    = '/' . ASSETS_FOLDER . '/admin';
		$template->frontAssets    = '/' . ASSETS_FOLDER . '/front';
		$template->frontImages    = $template->frontAssets . '/img';
		$template->webSettings    = $this->settings->getAll();
		$template->lang           = $this->translator->getLocale();
		$template->webColors      = $this->webColors->getColors($site->getIdent());
		$template->isMultiSiteWeb = count($this->sites->getSites()) > 1 ? true : false;
		$template->pshkCopyright  = '<div id="pshk-copyright">&copy; by <a href="https://www.pshk.cz" target="_blank">PSHK s.r.o.</a></div>';

		return $template;
	}
}
