<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Nette\Neon\Neon;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20191129123318 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE core__site (ident VARCHAR(255) NOT NULL, logo VARCHAR(255) DEFAULT NULL, site_name_separator VARCHAR(255) DEFAULT NULL, email VARCHAR(255) DEFAULT NULL, PRIMARY KEY(ident)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE core__site_text (lang VARCHAR(255) DEFAULT \'cs\' NOT NULL, site VARCHAR(255) NOT NULL, domain VARCHAR(255) NOT NULL, site_name VARCHAR(255) DEFAULT NULL, is_default SMALLINT DEFAULT 0 NOT NULL, INDEX IDX_71C13FC2694309E4 (site), PRIMARY KEY(site, lang)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE core__site_text ADD CONSTRAINT FK_71C13FC2694309E4 FOREIGN KEY (site) REFERENCES core__site (ident) ON DELETE CASCADE');
	}

	public function postUp(Schema $schema): void
	{
		$configFile = @file_get_contents(APP_DIR . '/config/app/parameters.neon');
		$params     = Neon::decode($configFile)['parameters'];

		$this->connection->insert('core__site', [
			'ident'               => $params['siteNameAlias'] ?? 'cms',
			'site_name_separator' => $params['siteNameSeparator'] ?? '|',
			'email'               => $params['contactForm']['toEmail'] ?? 'webmaster@pshk.cz',
		]);

		$this->connection->insert('core__site_text', [
			'site'       => $params['siteNameAlias'] ?? 'cms',
			'lang'       => $params['translation']['default'] ?? 'cs',
			'domain'     => 'localhost',
			'site_name'  => $params['siteName'] ?? 'PSHK CMS',
			'is_default' => 1,
		]);
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE core__site_text DROP FOREIGN KEY FK_71C13FC2694309E4');
		$this->addSql('DROP TABLE core__site');
		$this->addSql('DROP TABLE core__site_text');
	}
}
