<?php declare(strict_types = 1);

namespace Core\Model\FilesManager;

use elFinder;
use elFinderConnector;
use Nette\Http\Session;
use Nette\Http\SessionSection;

class FilesManager
{
	/** @var array */
	protected $options = [];

	/** @var array */
	protected $params = [];

	/** @var SessionSection */
	protected $sessionSection;

	/** @var elFinderConnector */
	private $connector;

	/** @var ElFinderImage */
	protected $elFinderImage;

	public function __construct($options, Session $session, ElFinderImage $elFinderImage)
	{
		$this->options        = $options;
		$this->sessionSection = $session->getSection('filemanager');
		$this->elFinderImage  = $elFinderImage;

		$this->options['bind']['rm rename'] = [$elFinderImage, 'removeThumbs'];
	}

	public function getConnector()
	{
		$roots = $this->sessionSection->roots;
		if (isset($this->params['rootsSession']) && $roots[$this->params['rootsSession']])
			foreach ($roots[$this->params['rootsSession']] as $key => $root)
				$this->options['roots'][$key] = $root;

		if (!$this->connector) {
			$this->connector = new elFinderConnector(new elFinder($this->options));
		}

		return $this->connector;
	}

	public function run($params)
	{
		$this->params = $params;
		$this->getConnector()->run();
	}
}