<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;

/**
 * Class SaveCancelControl
 * @package Core\Model\UI\Form\Controls
 */
class SaveCancelControl extends BaseContainer
{
	/**
	 * SaveCancelControl constructor.
	 *
	 * @param string|null $saveCaption
	 * @param string|null $saveAndCloseCaption
	 * @param string|null $cancelCaption
	 */
	public function __construct($saveCaption = null, $saveAndCloseCaption = null, $cancelCaption = null)
	{
		$this->addSubmit('save', $saveCaption ?: 'default.save')->getControlPrototype()->addHtml('<i class="fa fa-save"></i>');
		$this->addSubmit('saveAndClose', $saveAndCloseCaption ?: 'default.saveAndClose')->getControlPrototype()->addHtml('<i class="fa fa-check"></i>');
		$this->addCancel('cancel', $cancelCaption ?: 'default.cancel')->setAttribute('onclick', 'window.history.go(-1);')
			->getControlPrototype()->addHtml('<i class="fa fa-times"></i>');
	}

	/**
	 * @param \Nette\ComponentModel\IComponent $obj
	 */
	protected function attached($obj)
	{
		parent::attached($obj);
	}

	/**
	 * @return \Iterator
	 */
	public function getControls()
	{
		if ($this->getForm()->onCancel) {
			$this['cancel']->setAttribute('onclick', null);
		}

		return parent::getControls();
	}

	/**
	 * @param bool $throw
	 *
	 * @return \Nette\Forms\Form|BaseForm|null
	 */
	public function getForm($throw = true)
	{
		return parent::getForm($throw);
	}

	public function closeModalOnCancel()
	{
		$this['cancel']->setAttribute('onclick', 'closeModal("' . $this['cancel']->getHtmlId() . '");');
	}
}
