import autoComplete from "@tarekraafat/autocomplete.js"

export class Autocomplete {
	constructor() {
		this.dataLoaded = [];
		this.lastXhr = [];

		this.initInputs();
	}

	initInputs() {
		document.querySelectorAll('[data-autocomplete-url]').forEach(input => {
			input.addEventListener('focus', e => {
				if (input.classList.contains('init'))
					return;

				input.classList.add('init');
				const url = input.dataset.autocompleteUrl;
				const inputId = input.id;
				const targetId = input.dataset.autocompleteTarget;
				const target = targetId ? document.getElementById(targetId) : null;

				input.parentElement.style.position = 'relative';

				new autoComplete({
					data: {
						src: async () => {
							if (this.dataLoaded[url])
								return this.dataLoaded[url];

							if (typeof this.lastXhr[url] !== 'undefined' && this.lastXhr[url].hasOwnProperty('abort'))
								this.lastXhr[url].abort();

							let source = await fetch(url, {
								method: 'GET',
							});

							const result = await source.json();

							this.dataLoaded[url] = [];
							for (let a in result) {
								let row = result[a];
								if (!row.id)
									row.id = a;

								this.dataLoaded[url][a] = row;
							}

							return this.dataLoaded[url];
						},
						key: ['id', 'name'],
						cache: true,
					},
					cache: false,
					selector: '#' + inputId,
					maxResults: 20,
					threshold: 1,
					resultsList: {
						render: true,
						destination: input,
						position: "afterend",
						element: "ul"
					},
					resultItem: {
						content: (data, source) => {
							source.innerHTML = data.index + ' | ' + data.value.name;
						},
						element: "li"
					},
					onSelection: feedback => {
						input.value = feedback.selection.value.name;
						if (target)
							target.value = feedback.selection.index;
					}
				});
			});
		});
	}
}
