import {tns} from "tiny-slider/src/tiny-slider";

export const PromoteApplet = (promoteAppletSlider) => {
	if (promoteAppletSlider) {
		const slider = tns({
			container           : promoteAppletSlider,
			items               : 1,
			controls            : false,
			autoplay            : true,
			edgePadding         : 0,
			mouseDrag           : true,
			autoplayButtonOutput: false,
			autoplayHoverPause  : true,
			onInit() {
				console.log("init");
			}
		});

		slider.events.on('indexChanged', (el) => {
			const realIndex = el.displayIndex;
			setActiveSliderItem(realIndex);
			const els = promoteAppletSlider.querySelector('.tns-nav-active');
		});

		document.querySelector('.promote-applet__arrow--right').addEventListener('click', () => {
			slider.goTo('next');
		});

		document.querySelector('.promote-applet__arrow--left').addEventListener('click', () => {
			slider.goTo('prev');
		});

		/**
		 * Ovladani slideru pomoc menu
		 */
		const promoteAppletMenuItems = document.querySelectorAll('.promote-applet__menu-item');
		promoteAppletMenuItems.forEach((el) => {
			el.addEventListener('click', () => {
				const id = parseInt(el.dataset.id) - 1;
				console.log(id);
				slider.goTo(id);
			});
		});
	}
};

const setActiveSliderItem = (id) => {
	const promoteAppletMenuItems = document.querySelectorAll('.promote-applet__menu-item');
	promoteAppletMenuItems.forEach(el => el.classList.remove('primary-bg-color'));
	const activeElement = document.querySelector(`.promote-applet__menu-item[data-id="${id}"]`);
	activeElement.classList.add('primary-bg-color');
};
