import {Autocomplete} from './components/autocomplete';

global.naja.addEventListener('start', e => {
	global.lastClicked = document.activeElement;
});

global.naja.addEventListener('complete', e => {
	// Automatická změna titulku pokud proběhne ajax a je potřeba ho změnit
	if (e.response.pageTitle)
		document.title = e.response.pageTitle;

	// Aktualizace html elementu podle response
	if (e.response.ajaxPlaceholders) {
		for (let [key, value] of Object.entries(e.response.ajaxPlaceholders)) {
			document.querySelectorAll('[data-ajax-placeholder="' + key + '"').forEach(el => {
				el.innerHTML = value;
			})
		}
	}
});

document.addEventListener('DOMContentLoaded', () => {
	new Autocomplete();
});

if (document.readyState === "complete") {
	new Autocomplete();
}
