import PhotoSwipe from "photoswipe";
import PhotoSwipeUI_Default from "photoswipe/dist/photoswipe-ui-default";

export default class PhotoSwipeInitializator {
	static init(options) {
		const pswpElement = document.querySelectorAll('.pswp')[0];
		document.querySelectorAll('[data-photoswipe]').forEach((el) => {
			el.addEventListener('click', (e) => {
				e.preventDefault();
				this.slides = [];
				this.slides.push(this.slideFactory(el));
				const groupId = el.dataset.photoswipe;

				if(groupId) {
					const otherSlidesInGroup = document.querySelectorAll(`[data-photoswipe="${groupId}"]`);
					otherSlidesInGroup.forEach(el => this.slides.push(this.slideFactory(el)));
				}

				// Manually setting image size
				// https://github.com/dimsemenov/PhotoSwipe/issues/796
				const gallery = new PhotoSwipe(pswpElement, PhotoSwipeUI_Default, this.slides, options);
				gallery.listen('gettingData', (index, item) => {
					if (item.w < 1 || item.h < 1) {
						const img = new Image();
						img.onload = function() {
							item.w = this.width;
							item.h = this.height;
							gallery.invalidateCurrItems();
							gallery.updateSize(true);
						};
						img.src = item.src;
					}
				});

				gallery.init();
			})
		});
	}
	static initGallery() {

	}
	static slideFactory(element) {
		let src = false;
		src = element.attributes.href ? element.href : src;
		src = element.dataset.href ? element.dataset.href : src;
		if (!src) throw Error("initialized data-photoswipe element does not have href attribute");
		return {src, w:0, h: 0, msrc: src}
	}
}