import $                    from 'jquery';
import jump                 from "jump.js";
import {slideDown, slideUp} from "es6-slide-up-down";

export class Utilities {
	static getSiblings(elem) {
		let siblings = [];
		let sibling = elem.parentNode.firstChild;

		while (sibling) {
			if (sibling.nodeType === 1 && sibling !== elem) {
				siblings.push(sibling);
			}
			sibling = sibling.nextSibling
		}

		return siblings;
	};

	static parentsContainClass(el, q, maxParents) {
		let parent = el;
		for (let i = 1; i <= maxParents; i++) {
			parent = parent.parentNode;

			if (parent && parent.classList.contains(q)) {
				return parent;
			}
		}

		return false;
	}

	static pathContainClass(path, q) {
		for (let i in path) {
			let el = path[i];

			if (el.classList.contains(q)) {
				return el;
			}
		}

		return null;
	}

	static toggleClass(element, className) {
		if (element.classList.contains(className))
			return element.classList.remove(className);
		return element.classList.add(className);

	}
}

export const scrollTo = (amount, speed = 1000) => {
	const body = $("html, body");
	body.stop().animate({scrollTop: amount}, 1000, 'swing', function () {
	});
};

export function responsive(func) {
	func();
	$(window).on('resize', function () {
		func();
	})
}

export function checkMedia(mediaWith, maxmin = "max") {
	return window.matchMedia('(' + maxmin + '-width: ' + mediaWith + 'px)').matches;
}

export function responsiveOnMedia(onMediaEnter, onMediaExit, mediaWith, maxmin = "max") {
	if (checkMedia(mediaWith, maxmin)) onMediaEnter();
	$(window).on('resize', function () {
		if (checkMedia(mediaWith, maxmin)) onMediaEnter();
		else onMediaExit();
	})
}

export function convertRemToPixels(rem) {
	return rem * parseFloat(getComputedStyle(document.documentElement).fontSize);
}

export function arrayRemove(arr, value) {
	return arr.filter((el) => {
		return el != value;
	});
}

export const clickNotifyClose = () => {
	document.querySelectorAll('.alert .close:not(.init)').forEach((el) => {
		el.classList.add('init');
		console.log('click');
		el.addEventListener('click', (e) => {
			el.parentElement.remove();
		});
	});
};

export const clickScrollToInit = () => {
	document.querySelectorAll(`[data-scroll-to]`).forEach((el) => {
		el.addEventListener('click', () => {
			const scrollTarget = el.dataset.scrollTo;
			jump(scrollTarget, {
				duration: 750,
				offset  : 100,
			});
		});
	});
};

export const menuHamburger = (hamburgerIcon, responsiveMenu) => {
	hamburgerIcon.addEventListener('click', () => {
		if (!responsiveMenu.classList.contains('active')) {
			slideDown(responsiveMenu);
			responsiveMenu.classList.add('active');
			hamburgerIcon.classList.add('top-menu__hamburger--active');
		} else {
			slideUp(responsiveMenu);
			responsiveMenu.classList.remove('active');
			hamburgerIcon.classList.remove('top-menu__hamburger--active');
		}
	});
};

export const menuOpenResponsiveSub = () => {
	document.querySelectorAll('[data-open-responsive-sub]').forEach(el => {
		el.addEventListener('click', () => {

			const id        = el.dataset.openResponsiveSub;
			const submenuEl = document.querySelector(`[data-responsive-sub="${id}"]`);

			if (submenuEl.classList.contains('mobil-sub-navigation__list--active')) {
				slideUp(submenuEl);
				submenuEl.classList.remove('mobil-sub-navigation__list--active');
				el.classList.remove('active');

			} else {
				slideDown(submenuEl);
				submenuEl.classList.add('mobil-sub-navigation__list--active');
				el.classList.add('active');
			}

		});
	})
};
